from collections import deque


class RollingStatTracker:
    def __init__(self, num_to_track, default):
        self.buffer = deque(maxlen=num_to_track)
        self.default = default
        self.total_sum = 0

    def track(self, item):
        self.buffer.append(item)
        self.total_sum += item

    def average(self):
        if len(self.buffer) != 0:
            return sum(self.buffer) / len(self.buffer)
        else:
            return self.default
